
local MakePlayerCharacter = require "prefabs/player_common"


local assets = { Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/winnie.zip" ),
		Asset( "ANIM", "anim/ghost_winnie_build.zip" ),
}

--these are the character's prefabs
local prefabs = 
{}

local start_inv = 
{}

local function common_postinit(inst)

	inst.avatar_tex   = "avatar_winnie.tex"
	inst.avatar_atlas = "images/avatars/avatar_winnie.xml"

	inst.avatar_ghost_tex   = "avatar_ghost_winnie.tex"
    inst.avatar_ghost_atlas = "images/avatars/avatar_ghost_winnie.xml"

	end


local function master_postinit(inst)

	--speech sound and map icon
	inst.soundsname = "wendy"
	inst:AddComponent("inspectable")
	inst.MiniMapEntity:SetIcon( "winnie.tex" )
	inst:AddTag("winniefarm_builder")
	

	--Stats

	local WalkSpeed = (TUNING.WILSON_WALK_SPEED)
	local RunSpeed = (TUNING.WILSON_RUN_SPEED)

   





	-- possibly have her drain sanity faster at night? 
    inst.components.sanity.night_drain_mult = 0.2

	inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH * .75)
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * .75)
	inst.components.combat.damagemultiplier = .75
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.25)
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY * .75)


	inst.components.eater:SetOmnivore (true)

		
end

STRINGS.CHARACTER_TITLES.winnie = "Winona the Invalid"
STRINGS.CHARACTER_NAMES.winnie = "Winona"
STRINGS.CHARACTER_DESCRIPTIONS.winnie = "*Farmgirl from the south. \n*Has a weak heart."
STRINGS.CHARACTER_QUOTES.winnie= "\"Charlie?\""



return MakePlayerCharacter("winnie", prefabs, assets, common_postinit, master_postinit, start_inv)